﻿Public Class Form1

    Private Sub btnRepeat_Click(sender As Object, e As EventArgs) Handles btnRepeat.Click
        Dim inputText As String = txtInput.Text
        Dim delimiter As String = txtDelimiter.Text
        If delimiter = "\n" Then
            delimiter = vbCrLf
        End If
        Dim repeatValue As Decimal

        ' Validate input
        If String.IsNullOrEmpty(inputText) Then
            MessageBox.Show("Please enter text to repeat.")
            Exit Sub
        End If

        If Not Decimal.TryParse(txtRepeats.Text, repeatValue) OrElse repeatValue <= 0 Then
            MessageBox.Show("Please enter a valid repetition number.")
            Exit Sub
        End If

        Dim fullRepeats As Integer = Math.Floor(repeatValue)
        Dim fraction As Decimal = repeatValue - fullRepeats

        Dim result As New System.Text.StringBuilder()

        ' Full repetitions
        For i As Integer = 1 To fullRepeats
            result.Append(inputText)
            If i < fullRepeats OrElse fraction > 0 Then
                result.Append(delimiter)
            End If
        Next

        ' Fractional repetition
        If fraction > 0 Then
            Dim partialLength As Integer =
                CInt(Math.Round(inputText.Length * fraction, MidpointRounding.AwayFromZero))

            If partialLength > 0 Then
                result.Append(inputText.Substring(0, Math.Min(partialLength, inputText.Length)))
            End If
        End If

        txtOutput.Text = result.ToString()
    End Sub

End Class
